#include <QtGui>
#include "sqlQueryMaker.h"

 #define MESSAGE \
     sqlQueryMaker::tr("<p>Message boxes have a caption, a text, " \
                "and any number of buttons, each with standard or custom texts." \
                "<p>Click a button to close the message box. Pressing the Esc button " \
                "will activate the detected escape button (if any).")

 sqlQueryMaker::sqlQueryMaker()
 {	 
	primaryInx = 0;
 }
 
QString sqlQueryMaker::clearTable()
 {	 
	makeClearQuery = (QObject::tr("drop table if exists ") + tableName +QObject::tr(";"));
	return makeClearQuery;
 }

QString sqlQueryMaker::createTable()
 {	 
	makeTableQuery = (QObject::tr("create table ") + tableName +QObject::tr("( hanseungheuck int ) ENGINE=INNODB") );
	return makeTableQuery;
 }

void sqlQueryMaker::TableName(const QString &name)
 {	 
	execQuery.clear();
	tableName = name;
 }

QString sqlQueryMaker::createField(int count, int inx, QString &FieldName, QString &DatyType, QString &length, bool null)
 {	

	filedInfos.clear();
	filedInfos = QObject::tr("ALTER TABLE ") + tableName;
	
	if(null == 0)
	filedInfos += (QObject::tr(" ADD COLUMN ")+FieldName+QObject::tr(" ")+ DatyType +QObject::tr("(")+length+QObject::tr(") ")+QObject::tr(" NULL;"));
	else
	filedInfos += (QObject::tr(" ADD COLUMN ")+FieldName+QObject::tr(" ")+ DatyType +QObject::tr("(")+length+QObject::tr(") ")+QObject::tr(" NOT NULL;"));

	return filedInfos;
 }

void sqlQueryMaker::PrimaryFields(bool key,QString &FieldName)
{
	if(key == 1)
	{
		if(primaryInx == 0)
		 FieldNames += FieldName;
		else
		 FieldNames += (QObject::tr(", ") + FieldName);
		 
		 primaryInx++;
	}	
}

int sqlQueryMaker::primaryFieldCount()
{
	qDebug() <<"primaryInx : "<< primaryInx;
	return primaryInx;
}

QString sqlQueryMaker::createPrimaryField()
{
	primaryFieldInfos = (QObject::tr("ALTER TABLE ")+ tableName + QObject::tr(" ADD PRIMARY KEY (") + FieldNames +QObject::tr("); "));
	return primaryFieldInfos;
}

QString sqlQueryMaker::endMakeTable()
 {	 
	endQuery = (("ALTER TABLE ") + tableName + (" DROP COLUMN hanseungheuck;"));

	QSqlQuery buffer(endQuery);
	qDebug() <<"ddddddddddddd"<< buffer.lastError();
	
	makeClearQuery.clear();	
	makeTableQuery.clear();
	tableName.clear();
	filedInfos.clear();
	FieldNames.clear();
	primaryFieldInfos.clear();

	primaryInx = 0;
	return endQuery;
 }

QString sqlQueryMaker::relaitonConf(QString &constraint,QString &currentTable, QString &currentFeild, QString &relationTable, QString &relationField, bool del,bool update)
{
	QString relaiton;
	relaiton.clear();
	relaiton = (("ALTER TABLE ") + currentTable + (" ADD CONSTRAINT ") + constraint + (" FOREIGN KEY (") + currentFeild
				+ (") REFERENCES ") + relationTable + (" (") + relationField +(")"));
	
	if(del == 1 && update == 1)
		relaiton += (relaitonDelete()+relaitonUpdate()+(";"));
	
	else if(del == 1 && update == 0)
		relaiton += (relaitonDelete()+(";"));

	else if(del == 0 && update == 1)
		relaiton += (relaitonUpdate()+(";"));
	else
		relaiton += (";");

	return relaiton;

}

QString sqlQueryMaker::relaitonDelete()
{
	QString del;
	del.clear();
	del = (" ON DELETE CASCADE ");

	return del;
}

QString sqlQueryMaker::relaitonUpdate()
{
	QString Update;
	Update.clear();
	Update = (" ON UPDATE CASCADE ");

	return Update;
}

QString sqlQueryMaker::tableNames()
{
	QString tables;
	tables.clear();
	tables = ("show tables;");

	return tables;
}

QString sqlQueryMaker::columnNames(QString &tableName)
{
	QString columns;
	columns.clear();
	columns = ("desc ")+tableName+(";");

	return columns;
}
